<?php
/**
 * The Header template for our theme
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="robots" content="noindex">
	<link rel="profile" href="https://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<!-- Google Tag Manager -->
	<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
	new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
	j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
	'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
	})(window,document,'script','dataLayer','GTM-M6294W4G');</script>
	<!-- End Google Tag Manager -->
	<script async custom-element="amp-auto-ads"
        src="https://cdn.ampproject.org/v0/amp-auto-ads-0.1.js">
	</script>
	<meta name="keywords" content="custom sportswear, custom team apparel, personalized tracksuits, custom shirts, sports   team uniforms, athletic wear, custom athletic wear, custom jerseys, custom t-shirts, team t-shirts, custom team shirts, personalized sportswear, custom hoodies, custom training gear, performance sportswear, customized sports clothing, sports apparel printing, sports uniforms, custom tracksuit sets, gym apparel, custom fitness clothing, sublimated sportswear, team sportswear, custom sports uniforms, custom school uniforms, personalized team wear, custom team kits, custom warm-up suits, sports clothing for clubs, branded sportswear, sportswear for schools, printed sportswear, teamwear supplier, high-quality sportswear, athletic team clothing, sports uniform manufacturer, custom apparel for teams, team tracksuits, team hoodie design, football team uniforms, basketball team shirts, cricket team clothing, rugby team kits, track and field uniforms, marathon shirts, custom running gear, training wear for teams, custom sportswear online, quick delivery sportswear, bulk sportswear orders, custom sports clothing supplier">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<?php if ( function_exists( 'wp_body_open' ) ) : ?>
		<?php wp_body_open(); ?>
	<?php endif; ?>
	<!-- Google Tag Manager (noscript) -->
	<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-M6294W4G"
	height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
	<!-- End Google Tag Manager (noscript) -->
	<amp-auto-ads type="adsense"
        data-ad-client="ca-pub-1056255642131925">
	</amp-auto-ads>

	<?php do_action( 'woodmart_after_body_open' ); ?>

	<div class="website-wrapper">
		<?php if ( woodmart_needs_header() ) : ?>
			<?php if ( ! function_exists( 'elementor_theme_do_location' ) || ! elementor_theme_do_location( 'header' ) ) : ?>
				<header <?php woodmart_get_header_classes(); // phpcs:ignore ?>>
					<?php whb_generate_header(); ?>
				</header>
			<?php endif ?>

			<?php woodmart_page_top_part(); ?>
		<?php endif ?>
